Imports System.Runtime.InteropServices

Public NotInheritable Class AboutForm

    Private BLUEBOXLib As BLUEBOXLibInterface

    Private Sub AboutForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Set the title of the form.
        Dim ApplicationTitle As String
        If My.Application.Info.Title <> "" Then
            ApplicationTitle = My.Application.Info.Title
        Else
            ApplicationTitle = System.IO.Path.GetFileNameWithoutExtension(My.Application.Info.AssemblyName)
        End If
        Me.Text = String.Format("About {0}", ApplicationTitle)

        If (IntPtr.Size = 8) Then
            BLUEBOXLib = New BLUEBOXLibClass_x64
        ElseIf (IntPtr.Size = 4) Then
            BLUEBOXLib = New BLUEBOXLibClass_x86
        End If

        ' Initialize all of the text displayed on the About Box.
        Me.LabelProductName.Text = My.Application.Info.ProductName

        Dim Vrs As New Version(My.Application.Info.Version.ToString())

        Me.LabelVersion.Text = String.Format("Version {0}.{1}.{2}", Vrs.Major, Vrs.Minor, Vrs.Revision)
        Me.LabelLibraryVersion.Text = "Library error"
        Me.LabelCopyright.Text = My.Application.Info.Copyright
        Me.LabelCompanyName.Text = My.Application.Info.CompanyName
        Me.TextBoxDescription.Text = My.Application.Info.Description

        Try
            ' Read the library version
            Dim SwRel As New System.Text.StringBuilder(255)

            If BLUEBOXLib._GetSwRelease(SwRel) = 0 Then
                Me.LabelLibraryVersion.Text = String.Format("Library {0}", SwRel)
            End If
        Catch ex As Exception
            MessageBox.Show(ex.Message & Chr(13) & Chr(13) & ex.ToString(), Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    Private Sub OKButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OKButton.Click
        Me.Close()
    End Sub

End Class
